<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Receipts — Upload #{{ $upload->id }}</title>
    <style>
        @page { size: A3 portrait; margin: 10mm; } /* printer & PDF */
        :root { --blue1:#9ecbff; --blue2:#eaf3ff; }
        body { margin:0; font-family: DejaVu Sans, Arial, sans-serif; color:#000; -webkit-print-color-adjust:exact; print-color-adjust:exact; }
        .page {
            width: 277mm; min-height: 390mm; /* A3 minus margins */
            margin: 0 auto 8mm auto; border: 1px solid #d0d0d0; position: relative;
            padding: 14mm 14mm 28mm 14mm; background: #fff; page-break-after: always;
        }
        .hdr {
            text-align:center; padding-bottom:6mm; border-bottom: 2px solid #2d6cdf; margin-bottom: 8mm;
        }
        .hdr .title { font-weight:700; font-size: 18pt; letter-spacing: .5px; }
        .hdr .sub { font-weight:700; color:#b00000; margin-top:2mm; }
        .box {
            border: 1px solid #2d6cdf; border-radius: 4px; padding: 6mm; margin: 4mm 0;
        }
        .line { margin: 2.5mm 0; }
        .two { display: flex; gap: 8mm; }
        .two > div { flex:1; }
        .footer {
            position:absolute; left:0; right:0; bottom:0; height: 24mm;
            background: linear-gradient(to top, var(--blue1), var(--blue2));
            border-top: 1px solid #9ab6e6; text-align:center; padding-top: 4mm; font-size: 10pt;
        }
        .right { text-align:right; }
        .muted { color:#444; }
        .lbl { font-weight:600; }
        @media print {
            .no-print { display:none !important; }
            body { background:#fff; }
        }
    </style>
</head>
<body onload="window.print()">
<div class="no-print" style="padding:12px;background:#fff;border-bottom:1px solid #ddd;position:sticky;top:0;">
    <button onclick="window.print()" style="padding:8px 14px;background:#2563eb;color:#fff;border:none;border-radius:6px;">Print Now</button>
</div>

@foreach($records as $r)
    <div class="page">
        <div class="hdr">
            <div class="title">ADMINISTRATIVE BUILDING</div>
            <div class="sub">अक्षता: शुभदा भवन्तु</div>
        </div>

        <div class="box">
            <div class="two">
                <div class="line"><span class="lbl">Receipt No:</span> {{ $r->receipt_no }}</div>
                <div class="line right"><span class="lbl">Print Date:</span> {{ now()->format('d/m/Y H:i') }}</div>
            </div>

            <div class="line"><span class="lbl">EMO Number:</span> {{ $r->emo_number }}</div>
            <div class="line"><span class="lbl">Product Code:</span> {{ $r->product_code }}</div>

            <div class="two">
                <div class="line"><span class="lbl">Sender Name:</span> {{ $r->sender_name }}</div>
                <div class="line"><span class="lbl">Sender Pincode:</span> {{ $r->sender_pincode }}</div>
            </div>

            <div class="line"><span class="lbl">Sender Address:</span> {{ $r->sender_address }}</div>

            <div class="two">
                <div class="line"><span class="lbl">Booking Date:</span> {{ optional($r->booking_date)->format('d/m/Y') }}</div>
                <div class="line"><span class="lbl">Acceptance Date:</span> {{ optional($r->acceptance_date)->format('d/m/Y') }}</div>
            </div>

            <div class="line"><span class="lbl">EMO Amount:</span> ₹{{ number_format($r->emo_amount, 2) }}</div>

            @if($r->emo_message)
                <div class="line"><span class="lbl">Message:</span> {{ $r->emo_message }}</div>
            @endif
        </div>

        <div class="right muted" style="margin-top:14mm;">
            In the Service of Lord Venkateswara<br>
            Executive Officer
        </div>

        <div class="footer">
            Encl: Swamyvari Photo and Akshinthalu · This is computer generated and does not bear signature
        </div>
    </div>
@endforeach
</body>
</html>
